#ifndef CE2_AES_Error_H
#define CE2_AES_Error_H

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/

#include "CryptoEngine2.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
*  Object name     :  CE2_AES_Error.h
*  State           :  %state%
*  Creation date   :  23.02.2007
*  Last modified   :  %modify_time%
*/
/** @file
* \brief contains error codes for AES functions.
*
*  \version CE2_AES_Error.h#1:cinc:1
*  \author Yermalayeu Ihar
* \remarks Copyright (C) 2006 by Discretix Technologies Ltd. All rights reserved.
*/


  /* DX_AES() error codes */
#define CE2_AES_DATA_IN_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x01)
#define CE2_AES_DATA_OUT_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x02)
#define CE2_AES_DATA_IN_SIZE_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x03)
#define CE2_AES_IV_COUNTER_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x04)
#define CE2_AES_KEY_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x05)
#define CE2_AES_KEY_SIZE_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x06)
#define CE2_AES_OPERATION_MODE_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x07)
#define CE2_AES_ENCRYPT_DECRYPT_FLAG_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x08)

/* CE2_AES_Wrap() error codes */
#define CE2_AES_WRAP_ILLEGAL_DATA_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x11)
#define CE2_AES_WRAP_DATA_LENGTH_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x12)
#define CE2_AES_WRAP_KEY_LENGTH_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x13)                  
#define CE2_AES_WRAP_ILLEGAL_WRAP_DATA_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x14)      
#define CE2_AES_WRAP_ILLEGAL_WRAP_DATA_LEN_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x15)  
#define CE2_AES_WRAP_ILLEGAL_WRAP_DATA_LENGTH_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x16)

/* CE2_AES_Unwrap() error codes */
#define CE2_AES_UNWRAP_ILLEGAL_WRAP_DATA_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x21)          
#define CE2_AES_UNWRAP_WRAP_DATA_LENGTH_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x22)          
#define CE2_AES_UNWRAP_KEY_LEN_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x23)                   
#define CE2_AES_UNWRAP_ILLEGAL_DATA_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x24)          
#define CE2_AES_UNWRAP_ILLEGAL_DATA_LEN_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x25)      
#define CE2_AES_UNWRAP_ILLEGAL_DATA_LENGTH_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x26)       

#ifdef __cplusplus
}
#endif

#endif
